/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef KDLIB_SCORE_H_
#define KDLIB_SCORE_H_

#include <limits>		// std::numeric_limits

namespace kdlib {
	struct score_t {
		double		score;
		float32_t	split_coord;
		int_t		axis;

		int			num_l, num_r, num_cross, num_planar;
		int			scored_lefts, scored_rights;
		int			planar_side;

		bool_t		is_space_cut;

		int			updates;		// could be funny to track.

		score_t(): 
			score(std::numeric_limits<double>::infinity()), split_coord(cst::inf_plus), axis(-1),
			num_l(0), num_r(0), num_cross(0), num_planar(0),
			scored_lefts(0), scored_rights(0),
			planar_side(-1),
			is_space_cut(false),
			updates(0)
		{}

		void	reset() { *this = score_t(); } // eh?
		bool_t	is_valid() const { return axis >= 0; }

		// various crap.
		// count_l,count_r, ratio_l,ratio_r
	};

}

#endif
